int pinEncoder=2;
int pinMotore=3;

volatile long giri_dt=0;  // giri fatti nel dt
long dt_giri= 1000;  // intervallo per valutare giri fatti

void setup() {
    Serial.begin(9600);
    pinMode(pinEncoder,INPUT);  
    pinMode(pinMotore,OUTPUT);  
    attachInterrupt(digitalPinToInterrupt(pinEncoder),contaGiri,RISING);
}


long t0=0;

void loop() {
  
  long dt=millis() - t0; 
  if (dt> dt_giri) {
    t0= millis(); 
    float rpm= (1000.0* giri_dt / dt_giri)*60.0;
    Serial.println(rpm); 
    giri_dt= 0;  // azzero giri fatti nel dt
  };

  analogWrite(pinMotore,255);

}

void contaGiri() { giri_dt++;}